///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu   = NULL;
    static HMENU DialogMenu   = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MainDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(MainDialog_hWnd, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1002, "www.NetWorkDLS.com");

        SendMessage(MainDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(MainDialog_hWnd, WM_SETICON, TRUE, (LPARAM)LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        StatusListBox_hWnd = GetDlgItem(MainDialog_hWnd, 1000);

        DialogMenu = LoadMenu(MainInstance, MAKEINTRESOURCE(100));
        SetMenu(MainDialog_hWnd, DialogMenu);

        if(AllOnHold == TRUE)
            ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_UNCHECKED, 30003, "Schedule On Hold");

        if(AllOnHold == FALSE)
            ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_CHECKED, 30003, "Schedule Ready");

        LoadJobHistory(StatusListBox_hWnd);

        CenterWindow(MainDialog_hWnd);

        StartupComplete = TRUE;

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE ) // Received A Message
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(StatusListBox_hWnd, 0, 0, nWidth, nHeight, TRUE);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam==10001) //- Close (Dialog Menu Command)
        {
            EndDialog(MainDialog_hWnd,0);
            return 0;
        }

        if(wParam==20001) //- Manual Backup (Dialog Menu Command)
        {
        	DialogBox(MainInstance, MAKEINTRESOURCE(101), MainDialog_hWnd, ManBackupDialog);
            return 0;
        }
        if(wParam==20002) //- Manual Restore (Dialog Menu Command)
        {
        	DialogBox(MainInstance, MAKEINTRESOURCE(102), MainDialog_hWnd, ManRestoreDialog);
            return 0;
        }

        if(wParam==30001) //- Maintain Schedule (Dialog Menu Command)
        {
            if(CurrentlyRunning == TRUE)
            {
                MessageBox(MainDialog_hWnd, "Please wait untill the current process has completed.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            if(AllOnHold == TRUE)
            {
                DialogBox(MainInstance, MAKEINTRESOURCE(104), MainDialog_hWnd, ScheduleDialog);
            }
            else{
                AllOnHold = TRUE;
                DialogBox(MainInstance, MAKEINTRESOURCE(104), MainDialog_hWnd, ScheduleDialog);
                AllOnHold = FALSE;
            }
            return 0;
        }
        if(wParam==30002) //- View Schedule (Dialog Menu Command)
        {
            DialogBox(MainInstance, MAKEINTRESOURCE(108), MainDialog_hWnd, ViewScheduleDialog);
            return 0;
        }

        if(wParam==30003) //- On Hold (Dialog Menu Command)
        {
            if(AllOnHold == TRUE)
            {
                ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_CHECKED, 30003, "Schedule Ready");
                AllOnHold = FALSE;
                return 0;
            }

            if(AllOnHold == FALSE)
            {
                ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_UNCHECKED, 30003, "Schedule On Hold");
                AllOnHold = TRUE;
                return 0;
            }

            return 0;
        }

        if(wParam==40001) //- About (Dialog Menu Command)
        {
            NetLogo(MainDialog_hWnd);
            return 0;
        }

//        if(wParam == 100) //- Okay (Dialog Command)
//        {
//            return 0;
//        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            NetLogo(MainDialog_hWnd);
            return 0;
        }

        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s", TitleCaption, FileVersion);
            MessageBox(MainDialog_hWnd, VersionText, "Application Version", MB_TASKMODAL);
            return 0;
        }

        if(LOWORD(wParam) == 1002) //- www.NetWorkDLS.com (SysMenu Command)
        {
            ShellExecute(0,"Open", "Http://www.NetWorkDLS.com", NULL, NULL, SW_SHOWNORMAL);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(MainDialog_hWnd,0);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

